function spiderplot(yax,lb,classid,th,classorder,legendpos)

% Plots the factor loadings (yax) as a spiderplot. 
% Colors the axis according to a partition of the variables (classid)
% The factor loadings above a certain threshold (th) is labeled in
% accordance with lb. 
% Classorder sorts the ordering of the classid
% legendpos ({'box'} | 'circle') refers to the legend position for the
% partitioning. 
% 
% March 2013 - Morten Arendt Rasmussen - mortenr@life.ku.dk
% 
% DEMO I/O: spiderplot(rand(30,1),cellstr(num2str((1:30)')),cellstr(num2str(sort(ceil(rand(30,1)*5)))),0.3,[1 3 5 2 4],'circle')

clun = unique(classid);
ncl = length(clun);
if nargin==4;
    classorder = 1:ncl;
    legendpos = {'box'}
end

% [classid id] = sort(classid);

id = [];
for i=1:ncl;
    id = [id;  find(ismember(classid,clun(classorder(i))))];
end
classid = classid(id);
lb = lb(id);
yax = yax(id);

col = colormap(hsv(ncl));

n = length(yax);
ang1 = linspace(0,2*pi,n+1)';
yax = [yax; yax(1)];
x = cos(ang1).*yax;
y = sin(ang1).*yax;

CR = max(yax)*[1.1 1.15];
ang2 = linspace(0,2*pi,2*n+1)';
for i=1:2;
    xxc(i,:) = cos(ang2)*CR(i);
    yyc(i,:) = sin(ang2)*CR(i);
    %     plot(xxc(i,:),yyc(i,:),'-','color','w');
end
xxc = [xxc(:,end-1) xxc(:,2:2:end)];
yyc = [yyc(:,end-1) yyc(:,2:2:end)];
ang2 = [ang2(end-1); ang2(2:2:end)];

% plot axes
hold on;
plotpatternmulticlass(x,y,xxc,yyc,ang2,yax,classid,clun,col,th,lb,legendpos)
plotcircleaxes(n,ang1,yax)
% plot pattern (if only one class)
plot(x,y,'.-');
% plot pattern if several classes
plotpatternmulticlass(x,y,xxc,yyc,ang2,yax,classid,clun,col,th,lb,{'none'})
hold off;
axis tight;
axis off;


%%%%%%%%%%%%%%%%%
function plotcircleaxes(n,ang,yax)

graycol = repmat(0.5,1,3);
% plot axes
my = max(yax);
for i=1:n;
    xx = [0 cos(ang(i))*my];
    yy = [0 sin(ang(i))*my];
    plot(xx,yy,'-','color',graycol);
    hold on;
end

nCR = 4;
CR = linspace(0,max(yax),nCR);
for i=1:nCR;
    xx = cos(ang)*CR(i);
    yy = sin(ang)*CR(i);
    plot(xx,yy,':','color',graycol); shg;
end
text(zeros(nCR,1),CR,num2str(CR',2))

function plotpatternmulticlass(x,y,xxc,yyc,ang,yax,classid,clun,col,th,lb,legendpos)

ncl = length(clun);
for i=1:ncl;
    id = find(ismember(classid,clun(i)));
    xx = [0 x(id)' 0];
    yy = [0 y(id)' 0];
    
    h = patch(xx,yy,col(i,:));
end

for i=1:ncl;
    id = find(ismember(classid,clun(i)));
    %     get(h)
    id = [id; id(end)+1];
    xx = xxc(:,id);
    yy = yyc(:,id);
    a = ang(id);
    lid = length(id);
    if lid/2==ceil(lid)/2;
        pt = [floor(lid/2) ceil(lid/2)];
        xc = mean(xx(2,pt));
        yc = mean(yy(2,pt));
        a = mean(a(pt));
    else
        pt = lid/2;
        xc = xx(2,pt);
        yc = yy(2,pt);
        a = a(pt);
    end
    %     xc =
    xx = [xx(1,:) fliplr(xx(2,:))];
    yy = [yy(1,:) fliplr(yy(2,:))];
    patch(xx,yy,col(i,:),'edgecolor',col(i,:));
    if ismember(legendpos,{'circle'})
        
        
        if a<pi;
            text(xc,yc,clun(i),'horizontalalignment','center','rotation',a*180/pi-90,'fontsize',12,'verticalalignment','middle')
        else
            text(xc,yc,clun(i),'horizontalalignment','center','rotation',a*180/pi+90,'fontsize',12,'verticalalignment','middle')
        end
    end
end
plot(x,y,'.-k');
x = x(1:end-1);
y = y(1:end-1);
n = length(yax);
yax = yax(1:end-1);
id = find(yax>th);

icc = id>n/4 & id<n*3/4;
text(x(id(~icc)),y(id(~icc)),lb(id(~icc)),'interpret','none','horizontalalignment','left');
text(x(id(icc)),y(id(icc)),lb(id(icc)),'interpret','none','horizontalalignment','right');

if ismember(legendpos,{'box'})
    legend(clun);
end